unit DemoKolejki;

interface

uses
  Generics.Collections;

type
  TZlecenie = record
    Opis: string;
    constructor Create(aOpis: string);
  end;

TKolejkaZlece = TQueue<TZlecenie>;

procedure Naprawy;

implementation

procedure WykonajZlecenie(aZlecenie: TZlecenie);
begin
  WriteLn('Teraz wykonywane jest zlecenie: ', aZlecenie.Opis);
end;

procedure Naprawy;
var
  KolejkaZlece: TKolejkaZlece;
  i: Integer;
begin
  KolejkaZlece := TKolejkaZlece.Create;
  try
    // Przychodz zlecenia
    KolejkaZlece.Enqueue(TZlecenie.Create('Uszczelnienie kranu 543'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Naprawa klimatyzacji 156'));

    // Wykonanie jednego zlecenia
    WykonajZlecenie(KolejkaZlece.Dequeue);

    // Przychodz nastpne zlecenia!
    KolejkaZlece.Enqueue(TZlecenie.Create('Zaopatrzenie zienki'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Naprawa zamka w drzwiach 307'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Zapanie myszy w 124'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Naprawa lodwki w 402'));

    // Dam rad tylko jedno zrobi!
    WykonajZlecenie(KolejkaZlece.Dequeue);

    // Coraz wicej pracy!!!
    KolejkaZlece.Enqueue(TZlecenie.Create('Udronienie toalety w 109'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Naprawa dywanu w 405'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Wymiana gaki w drzwiach w 322'));
    KolejkaZlece.Enqueue(TZlecenie.Create('Naprawa klimatyzacji w 143'));

    // No dobrze, zaatwmy wszystko od razu

    while KolejkaZlece.Count > 0 do
    begin
      WykonajZlecenie(KolejkaZlece.Dequeue);
    end;

  finally
    KolejkaZlece.Free;
  end;
end;


{ TZlecenie }

constructor TZlecenie.Create(aOpis: string);
begin
  Opis := aOpis;
end;

end.

